\version "2.24.0"
\language "deutsch"

\paper {
  markup-system-spacing = #'((basic-distance . 19))
  system-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Cântă cucu, bată-l vina"
  subtitle = " "
  %subsubtitle = " "
  composer = \markup \center-column { "Constantin Mandicevschi" \small 
  "(1859–1933)" }
  %poet = "Karl Barth"
  %arranger = "arm. după I. D. Chirescu"
  %meter = "Largo"
  tagline=""
}

global = {
  \key c \major
  %\autoBeamOff
  %\cadenzaOn
  %\time 2/4
  %\partial 2
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
 \set stanza = "1."
 Cân -- tă cu -- cu, ba -- tă-l vi -- na,
 de ră -- su -- nă Bu -- co -- vi -- na.
 Cân -- tă cu -- cu-n -- tr-un bră -- duț, __
 de ră -- su -- nă-n Cer -- nă -- uți, __
 cân -- tă cu -- cu-n -- tr-un bră -- duț, __
 de ră -- su -- nă-n Cer -- nă -- uți. 
}

womenWordsTwo = \lyricmode {
 \set stanza = "2."
 Bu -- co -- vi -- nă, plai cu flori, __ \skip1
 un -- de sunt ai tăi fe -- ciori? __ \skip1
 Au fost duși în al -- tă ța-ră,
 dar se-n -- torc la primă -- va -- ră. __
 Î -- na -- poi când or ve -- ni, __
 tot pe ti -- ne te-or iu -- bi.
} 

womenWordsThree = \lyricmode {
 \set stanza = "3."
 Mun -- ți -- lor cu creas -- ta ra -- ră,
 nu lă -- sați stra -- ja să pia -- ră.
 Da -- că pie -- re stra -- ja voas-tră,
 a pie -- rit și țara noas -- tră, __
 da -- că pie -- re stra -- ja voas-tră,
 a pie -- rit și țara noas -- tră. 
} 

menWords = \lyricmode {
  
}
  
sopMusic = \relative c' {
 d8[ d] f f e e d4 c2. h'4\rest
 f8[ f] a a g g f( e) d2. h'4\rest
 a4. d8 d c4. f,4. a8 a( g4.) 
 f8 f a a g4 f8( e) d( a'2.) h8\rest
 a4. d8 d c4. f,4. a8 a( g4.) 
 f8 f a a g4 f8( e) d2. h'4\rest
 \bar"|."  
}

altMusic = \relative c' {
 d8[ d] d d c c h4 c2. h'4\rest
 d,8[ d] f f e e h( c) d2. h'4\rest
 f4. f8 a a4. f4. f8 f( e4.)
 d8 d f f e4 c d2..  h'8\rest
 %d8 d f f g4 c8( h) a2..  h8\rest
 f4. f8 a a4. f4. f8 f( e4.)
 d8 d f f e4 h8( c) d2.  h'4\rest
}

bassMusic = \relative c {
 %d8[ d] d d a a a4 c2. r4
 
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \sopMusic }
      \addlyrics { \womenWordsOne }
      \addlyrics { \womenWordsTwo }
      \addlyrics { \womenWordsThree }
      %\new Voice { \global \voiceTwo \altMusic }      
    >>
    \new Staff <<
      %\clef bass
      \new Voice { \global \altMusic }      
      %\new Voice { \global \bassMusic }
      \addlyrics { \womenWordsOne }
      \addlyrics { \womenWordsTwo }
      \addlyrics { \womenWordsThree }
      %\addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 78
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}